/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Migration;
import website.eccentric.tome.ModName;
import website.eccentric.tome.Tag;
import website.eccentric.tome.TomeItem;

public class Tome {
    public static ItemStack convert(ItemStack tome, ItemStack book) {
        Map<String, List<ItemStack>> modsBooks = Tome.getModsBooks(tome);
        String mod = ModName.from(book);
        List<ItemStack> books = modsBooks.get(mod);
        ResourceLocation registry = book.m_41720_().getRegistryName();
        books.removeIf(b -> {
            ResourceLocation location = b.m_41720_().getRegistryName();
            if (location == null) {
                return false;
            }
            return location.equals((Object)registry);
        });
        Tome.setModsBooks(book, modsBooks);
        Migration.setVersion(book);
        book.m_41784_().m_128379_(Tag.IS_TOME, true);
        Tome.setHoverName(book);
        return book;
    }

    public static ItemStack revert(ItemStack book) {
        Migration.apply(book);
        ItemStack tome = new ItemStack((ItemLike)EccentricTome.TOME.get());
        Tome.copyMods(book, tome);
        Migration.setVersion(tome);
        Tome.clear(book);
        return tome;
    }

    public static ItemStack attach(ItemStack tome, ItemStack book) {
        String mod = ModName.from(book);
        Map<String, List<ItemStack>> modsBooks = Tome.getModsBooks(tome);
        List books = modsBooks.getOrDefault(mod, new ArrayList());
        books.add(book);
        modsBooks.put(mod, books);
        Tome.setModsBooks(tome, modsBooks);
        return tome;
    }

    public static Map<String, List<ItemStack>> getModsBooks(ItemStack stack) {
        return Tag.deserialize(stack.m_41698_(Tag.MODS));
    }

    public static void setModsBooks(ItemStack stack, Map<String, List<ItemStack>> modsBooks) {
        stack.m_41784_().m_128365_(Tag.MODS, (net.minecraft.nbt.Tag)Tag.serialize(modsBooks));
    }

    public static boolean isTome(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41720_() instanceof TomeItem) {
            return true;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128471_(Tag.IS_TOME);
    }

    @Nullable
    public static InteractionHand inHand(Player player) {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack stack = player.m_21120_(hand);
        if (Tome.isTome(stack)) {
            return hand;
        }
        hand = InteractionHand.OFF_HAND;
        stack = player.m_21120_(hand);
        if (Tome.isTome(stack)) {
            return hand;
        }
        return null;
    }

    private static void copyMods(ItemStack source, ItemStack target) {
        CompoundTag tag = target.m_41784_();
        tag.m_128365_(Tag.MODS, (net.minecraft.nbt.Tag)source.m_41737_(Tag.MODS));
    }

    private static void clear(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_(Tag.MODS);
        tag.m_128473_(Tag.IS_TOME);
        tag.m_128473_(Tag.VERSION);
        stack.m_41787_();
    }

    private static void setHoverName(ItemStack book) {
        MutableComponent name = book.m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN);
        book.m_41714_((Component)new TranslatableComponent("eccentrictome.name", new Object[]{name}));
    }
}

